//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using System.Diagnostics;
using System.ComponentModel;
using System.ComponentModel.Design;
using System.IO;

namespace LicenseTimeBombClass
{
	/// <summary>
	/// Podsumowanie dla TimeBombLicenseProvider.
	/// </summary>
	public class TimeBombLicenseProvider : LicenseProvider
	{
		protected virtual bool IsKeyValid(string key, Type type) 
		{
			// Jeli cig nie jest pusty
			if (key != null) 
			{
				DateTime now = DateTime.Now;
				// Uzyskanie liczby procesorw, dla ktrych jest wana licencja.
				int startIndex = key.IndexOf(',') + 1;
				int endIndex = key.IndexOf(',', startIndex) + 1;
				DateTime validStartTime = new DateTime(Convert.ToInt64(key.Substring(startIndex, endIndex - startIndex - 1)));
				DateTime validEndTime = new DateTime(Int64.Parse(key.Substring(endIndex)));
				
				Debug.WriteLine("Data pocztkowa: " + validStartTime.ToString() + " Data kocowa: " + validEndTime.ToString() + "\n" + "Teraz: " + now.ToString());

				Debug.WriteLine(string.Format("Obecna data jest pniejsza ni data pocztkowa: {0}", now > validStartTime));
				Debug.WriteLine(string.Format("Obecna data jest wczeniejsza ni data kocowa: {0}", now < validEndTime));
				// Potwierdzenie cigu licencji i liczby procesorw.
				return (now > validStartTime && now < validEndTime && key.StartsWith(string.Format("{0} jest licencjonowanym komponentem.",type.FullName)));
			}
			return false;
		}

		public override License GetLicense(LicenseContext context, Type type, object instance, bool allowExceptions) 
		{
			TimeBombLicense lic = null;
            
			Debug.Assert(context != null, "No context provided!");
			// adna operacja nie jest wykonywana, jeli nie podano kontekstu.
			if (context != null) 
			{
				// Jeli ten element sterujcy znajduje si w trybie runtime
				if (context.UsageMode == LicenseUsageMode.Runtime) 
				{
					// Uzyskanie zapisanego klucza licencji
					string key = context.GetSavedLicenseKey(type, null);

					// Sprawdzenie, czy zapisany klucz licencji nie jest pusty
					// i wywoanie IsKeyValid w celu upewnienia si,
                    // czy klucz licencji jest wany.
					if (key != null && IsKeyValid(key, type)) 
					{
						// Jeli klucz jest wany, naley utworzy now licencj.
						lic = new TimeBombLicense(this, key);
					}
				}

				// W trybie projektu lub w przypadku nieodnalezienia klucza
				// licencji w kontekcie runtime naley podj prb
				// wyszukania pliku .LIC.
				if (lic == null) 
				{
					// Utworzenie cieki do pliku .LIC
					string modulePath = null;

					// Prba odnalezienia pliku dla podzespou.
					if (context != null) 
					{
						ITypeResolutionService resolver = (ITypeResolutionService)context.GetService(typeof(ITypeResolutionService));
						if (resolver != null)
							modulePath = resolver.GetPathOfAssembly(type.Assembly.GetName());
					}


					if (modulePath == null)
						modulePath = type.Module.FullyQualifiedName;

					// Uzyskanie cieki z pooenia pliku
					string moduleDir = Path.GetDirectoryName(modulePath);
					
					// Utworzenie cieki pliku .LIC.
					string licenseFile = moduleDir + "\\" + type.FullName + ".lic";

					Debug.WriteLine("Path of license file: " + licenseFile);

					// Jeli plik .LIC istnieje, naley go zbada
					if (File.Exists(licenseFile)) 
					{
						// Odczyt pierwszego wiersza
						Stream licStream = new FileStream(licenseFile, FileMode.Open, FileAccess.Read, FileShare.Read);
						StreamReader sr = new StreamReader(licStream);
						string s = sr.ReadLine();
						sr.Close();

						Debug.WriteLine("Zawarto pliku licencji: " + s);

						// Sprawdzenie, czy klucz jest wany.
						if (IsKeyValid(s, type)) 
						{
							// Klucz jest wany, a wic mona utworzy now licencj.
							lic = new TimeBombLicense(this, s);
						}
					}

					// Jeli udao si utworzy licencj, to naley umieci j w kontekcie.
					if (lic != null) 
					{
						context.SetSavedLicenseKey(type, lic.LicenseKey);
					}
				}

			}
			return lic;
		}
		public class TimeBombLicense : License 
		{
			private TimeBombLicenseProvider owner;
			private string key;
			private DateTime validStartTime;
			private DateTime validEndTime;

			public TimeBombLicense(TimeBombLicenseProvider owner, string key) 
			{
				this.owner = owner;
				this.key = key;
				int startIndex = key.IndexOf(',') + 1;
				int endIndex = key.IndexOf(',', startIndex) + 1;
				this.validStartTime = new DateTime(Convert.ToInt64(key.Substring(startIndex, endIndex - startIndex - 1)));
				this.validEndTime = new DateTime(Int64.Parse(key.Substring(endIndex)));
			}
			public override string LicenseKey 
			{ 
				get 
				{
					return key;
				}
			}

			public DateTime ValidStartTime 
			{
				get 
				{
					return validStartTime;
				}
			}
			public DateTime ValidEndTime 
			{
				get 
				{
					return validEndTime;
				}
			}

			public override void Dispose() 
			{
			}
		}
	}
}
